package gov.va.med.mhv.vitals.dto;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.vitals.enums.TemperatureMeasureEnumeration;
import gov.va.med.mhv.vitals.enums.TemperatureMethodEnumeration;

@XmlRootElement(name = "BodyTemperatureDTO")
public class BodyTemperatureDTO extends AbstractDTO implements Serializable{
	
    private static final long serialVersionUID = -4034010697239373246L;
  
    private Long bodyTemperatureId;
    private String comments;
    private BigDecimal bodyTemperature;
    private Long userprofileId;
    private TemperatureMeasureEnumeration bodyTempMeassure = TemperatureMeasureEnumeration.F; 
    private TemperatureMethodEnumeration bodyTempMethod = TemperatureMethodEnumeration.M;
    
	public Long getBodyTemperatureId() {
		return bodyTemperatureId;
	}
	public void setBodyTemperatureId(Long bodyTemperatureId) {
		this.bodyTemperatureId = bodyTemperatureId;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getBodyTemperatureMethod() {
		return bodyTempMethod.name();
	}
	public void setBodyTemperatureMethod(String bodyTemperatureMethod) {
		this.bodyTempMethod = TemperatureMethodEnumeration.valueOf(bodyTemperatureMethod);
	}
	public BigDecimal getBodyTemperature() {
		return bodyTemperature;
	}
	public void setBodyTemperature(BigDecimal bodyTemperature) {
		this.bodyTemperature = bodyTemperature;
	}
	@JsonIgnore
	public TemperatureMeasureEnumeration getBodyTempMeassure() {
		return bodyTempMeassure;
	}
	@JsonIgnore
	public TemperatureMethodEnumeration getBodyTempMethod() {
		return bodyTempMethod;
	}
	public String getMeasure() {
		return bodyTempMeassure.name();
	}
	public void setMeasure(String measure) {
		this.bodyTempMeassure = TemperatureMeasureEnumeration.valueOf(measure);
	}
	public Long getUserprofileId() {
		return userprofileId;
	}
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	@JsonIgnore
	public String getDisplayBodyTemperatureMethod() {
		return this.bodyTempMethod.getDescription();
	}
	@JsonIgnore
	public String getDispalyMeasure() {
		return this.bodyTempMeassure.getDescription();
	}
	@JsonIgnore
	public TemperatureMeasureEnumeration[] getTempMeasures() {
		return TemperatureMeasureEnumeration.values();
	}
	@JsonIgnore
	public TemperatureMethodEnumeration[] getTempMethods() {
		return TemperatureMethodEnumeration.values();
	}
}
